/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking.forge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.apace100.origins.OriginsForge;
import io.github.apace100.origins.networking.packet.AcknowledgeMessage;
import io.github.apace100.origins.networking.packet.DynamicRegistryMessage;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.util.SerializableData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeNetworkHandler {
    public static void initializeNetwork() {
        SimpleChannel channel = OriginsForge.channel;
        channel.messageBuilder(AcknowledgeMessage.class, 0, NetworkDirection.LOGIN_TO_SERVER).loginIndex(AcknowledgeMessage::getLoginIndex, AcknowledgeMessage::setLoginIndex).encoder(AcknowledgeMessage::encode).decoder(AcknowledgeMessage::decode).consumer(FMLHandshakeHandler.indexFirst((handler, message, context) -> message.handle((Supplier<NetworkEvent.Context>)context))).add();
        channel.messageBuilder(DynamicRegistryMessage.class, 1, NetworkDirection.LOGIN_TO_CLIENT).loginIndex(DynamicRegistryMessage::getLoginIndex, DynamicRegistryMessage::setLoginIndex).encoder(DynamicRegistryMessage::encode).decoder(DynamicRegistryMessage::decode).consumer(DynamicRegistryMessage::handle).buildLoginPacketList(ForgeNetworkHandler::createRegistries).add();
    }

    private static List<Pair<String, DynamicRegistryMessage>> createRegistries(boolean isLocal) {
        DynamicRegistryMessage message = new DynamicRegistryMessage((Map<ResourceLocation, PowerType<?>>)ImmutableMap.copyOf(PowerTypeRegistry.entries()), (Map<ResourceLocation, SerializableData.Instance>)ImmutableMap.copyOf((Map)((Map)OriginRegistry.identifiers().filter(x -> !Objects.equals(x, Origin.EMPTY.getIdentifier())).collect(ImmutableMap.toImmutableMap(Function.identity(), x -> OriginRegistry.get(x).dataInstance())))), (List<OriginLayer>)ImmutableList.copyOf(OriginLayers.getLayers()));
        return ImmutableList.of((Object)Pair.of((Object)"Origins registries", (Object)message));
    }
}

